/*
REM
REM q07.sql
REM
REM Find the manufacturer(s) of the computer(PC or laptop)
REM with the highest available speed.
REM
*/

\. set-db.sql

CREATE VIEW ProdSpeed(model, speed)
  AS (SELECT model, speed
      FROM PC
      WHERE speed IN (SELECT MAX(speed)
                      FROM  PC))
     UNION
     (SELECT model, speed
      FROM Laptop
      WHERE speed IN (SELECT MAX(speed)
                      FROM  Laptop));

SELECT P.maker, S.speed
FROM Product P, ProdSpeed S
WHERE P.model=S.model
  AND S.speed IN (SELECT MAX(speed)
                  FROM ProdSpeed);
