/*
REM
REM q10.sql
REM
REM Find the maker of the printer with the fastest processor
REM among all those PC's that have the smallest amount of RAM.
REM
*/

\. set-db.sql

CREATE VIEW SmallRam(model,ram)
  AS (SELECT model, ram
      FROM PC
      WHERE ram IN (SELECT MIN(ram)
                    FROM  PC));

SELECT P.maker
FROM Product P, PC C, SmallRam S
WHERE P.model=C.model
  AND C.model=S.model
  AND C.speed IN (SELECT MAX(speed)
                  FROM PC, SmallRam S
                  WHERE PC.model= S.model);
