/*
REM
REM q05.sql
REM
REM Which stars appeared in movies produced by
REM 'Disney' studios in 1997 but not in 1998
REM 'Disney' movies.
REM
*/

\. set-db.sql

SELECT SI.name
FROM Movie M, StarsIn SI
WHERE M.year = 1997
  AND M.studioname = 'Disney'
  AND M.title = SI.title
  AND SI.name NOT IN (SELECT SI.name
                      FROM Movie M, StarsIn SI
                      WHERE M.year = 1998
                        AND M.studioname = 'Disney'
                        AND M.title = SI.title);
