/*
REM
REM q03.sql
REM
REM Get supplier numbers for suppliers supplying some project
REM with part 'P02' in a quantity greater than the
REM average shipment quantity of part 'P02' for that project.
REM
*/

\. set-db.sql

SELECT DISTINCT S.sn
FROM Shipments S
WHERE pn = 'P2'
  AND quantity > (SELECT AVG(T.quantity)
                  FROM Shipments T
                  WHERE pn = 'P2'
                    AND S.jn = T.jn);
