/*
REM
REM q110.sql
REM
REM Find all customers who have an account at all branches
REM located in 'Brooklyn'.
REM
*/

\. set-db.sql

SELECT DISTINCT S.customername
FROM Depositor S
WHERE NOT EXISTS 
  (SELECT branchname
   FROM Branch
   WHERE branchcity = 'Brooklyn'
     AND branchname NOT IN (SELECT T.branchname
                            FROM Depositor T
                            WHERE S.customername = T.customername));
