/*
REM
REM q07.sql
REM
REM Get project numbers for projects supplied with part 'P01'
REM in an average quantity greater than the greatest quantity
REM in which any part is supplied to project 'J01'.
REM
*/

\. set-db.sql

SELECT DISTINCT jn
FROM Shipments
WHERE pn = 'P1'
GROUP BY jn
HAVING AVG(quantity) > (SELECT MAX(quantity)
                        FROM Shipments
                        WHERE jn='J01');
