/*
REM
REM q06.sql
REM
REM Find those manufacturers of at least two different
REM computers (PC's or laptops) with speeds of at least 133.
REM
*/

\. set-db.sql

SELECT maker
FROM Product
WHERE model IN ( (SELECT P.model
                  FROM Product P, PC
                  WHERE P.model=PC.model
                    AND PC.speed>=133)
                  UNION
                 (SELECT P.model
                  FROM Product P, Laptop L
                  WHERE P.model=L.model
                    AND L.speed>=133) )
GROUP BY maker
HAVING COUNT(model)>=2;
