--  Copyright 1998-2003 Simon Wright <simon@pushface.org>

--  This package is free software; you can redistribute it and/or
--  modify it under terms of the GNU General Public License as
--  published by the Free Software Foundation; either version 2, or
--  (at your option) any later version. This package is distributed in
--  the hope that it will be useful, but WITHOUT ANY WARRANTY; without
--  even the implied warranty of MERCHANTABILITY or FITNESS FOR A
--  PARTICULAR PURPOSE. See the GNU General Public License for more
--  details. You should have received a copy of the GNU General Public
--  License distributed with this package; see file COPYING.  If not,
--  write to the Free Software Foundation, 59 Temple Place - Suite
--  330, Boston, MA 02111-1307, USA.

--  $Id: smart_test_support.ads,v 1.3.2.2 2003/01/05 17:49:18 simon Exp $

with Ada.Finalization;
with BC.Support.Smart_Pointers;

package Smart_Test_Support is

   --  This type is used to test BC.Smart. It's Controlled simply so
   --  that we can see when instances are deleted.
   type T is new Ada.Finalization.Controlled with record
      C : Character;
   end record;
   type P is access T;

   procedure Finalize (The_T : in out T);

   package Smart is new BC.Support.Smart_Pointers (T => T, P => P);

   function Create (Ch : Character) return Smart.Pointer;
   function Value (P : Smart.Pointer) return Character;

end Smart_Test_Support;
